## 前言：

Ubuntu与其他Linux系统不相同，由于Ubuntu特性不能直接在登录界面进行登录，在安装系统的时候也没有设置root用户配置的地方，所以需要用到刚安装系统时创建的普通用户。

## 当前环境
ubuntu-18.04-desktop-amd64

## 1.设置root密码并登录root

```bash
sudo passwd root
```

![](.\Image\1.png)


```bash
su root
```

![](.\Image\2.png)

## 2.修改配置文件

### 1)修改/etc/pam.d/gdm-autologin

(注意：gedit是打开桌面环境的编辑器，如果是最小安装的话可以使用vi，或者vim进行文件修改)

```bash
gedit /etc/pam.d/gdm-autologin
```

原文件部分内容：

```bash
#%PAM-1.0
auth    requisite       pam_nologin.so
auth	required		pam_succeed_if.so user != root quiet_success
auth	optional		pam_gdm.so
auth	optional		pam_gnome_keyring.so
auth    required        pam_permit.so
```

修改后：

```bash
#%PAM-1.0
auth    requisite       pam_nologin.so
#auth	required		pam_succeed_if.so user != root quiet_success
auth	optional		pam_gdm.so
auth	optional		pam_gnome_keyring.so
auth    required        pam_permit.so
```

### 2)修改/etc/pam.d/gdm-password


```bash
gedit /etc/pam.d/gdm-password
```

原文件部分内容：


```bash
#%PAM-1.0
auth    requisite       pam_nologin.so
auth	required	pam_succeed_if.so user != root quiet_success
@include common-auth
auth    optional        pam_gnome_keyring.so
```

修改后：


```bash
#%PAM-1.0
auth    requisite       pam_nologin.so
auth	required	pam_succeed_if.so user != root quiet_success
@include common-auth
auth    optional        pam_gnome_keyring.so
```

### 3)修改/root/.profile

```
gedit /root/.profile
```

原文件内容：


```bash
# ~/.profile: executed by Bourne-compatible login shells.

if [ "$BASH" ]; then
  if [ -f ~/.bashrc ]; then
    . ~/.bashrc
  fi
fi

mesg n || true
```

修改后：


```bash
# ~/.profile: executed by Bourne-compatible login shells.

if [ "$BASH" ]; then
  if [ -f ~/.bashrc ]; then
    . ~/.bashrc
  fi
fi

# mesg n || true
tty -s && mesg n || true
```

## 3.重启主机
选择未列出
输入root的账号密码即可登录