# f8X平台搭建工具

### 1. 安装环境

- 本环境为Ubantu 18.04 64位

### 2. 下载所需要的包和集成环境

#### 相关包

- <1>. 更新apt-get源

  ```bash
   apt-get update
  ```

- <2>. 安装docker

  ```bash
  apt-get install docker
  ```

- <3>. 安装docker-compose

  ```bash
  apt-get install -y docker-compose
  ```

#### 集成安装环境

- <1>. 切换到"/"目录,创建"f8x"并进入"f8x"目录

  ```bash
  cd /;mkdir f8x;cd f8x
  ```

- <2>. 下载f8x集成环境

  ```bash
  wget : wget -O f8x https://f8x.io/
  ```

- <3>. 可查看集成安装环境详细使用命令

  ```bash
  bash f8x -h
  ```
  ```
    _______   ___   ___   ___ 
   |   ____| / _ \  \  \ /  / 
   |  |__   | (_) |  \  V  / 
   |   __|   > _ <    >   < 
   |  |     | (_) |  /  .  \ 
   |__|      \___/  /__/ \__\ 
  
  UID           : 0 
  User          : root 
  Date          : 2024-04-15 
  Time          : 13:21:51 
  Runtime       : 3min 
  Hostname      : XXX
  Distribution  : XXX
  f8x Version   : 1.7.4 Dev(2024/03/25) 
  
  -----Start execution----- 
  
  >> Initializing
  
  13:21:51 [INFOR] - /ffffffff0x folder created
  
  
  Batch installation 
    -b                : install Basic Environment          (gcc、make、git、vim、telnet、jq、unzip ...)
    -p                : install Proxy Environment          (Warning : Use only when needed)
    -d                : install Development Environment    (python3、pip3、Go、Docker、Docker-Compose、SDKMAN)
    -k(a/b/c/d/e)     : install Pentest environment        (hashcat、ffuf、OneForAll、ksubdomain、impacket ...)
    -s                : install Blue Team Environment      (Fail2Ban、chkrootkit、rkhunter、shellpub)
    -f                : install Other Tools                (AdguardTeam、trash-cli、fzf)
    -cloud            : install Cloud Applications         (Terraform、Serverless Framework、wrangler)
    -all              : fully automated deployment
  
  Development Environment 
    -docker           : install docker
    -docker-cn        : install docker (aliyun source)
    -lua              : install lua
    -nn               : install npm & NodeJs
    -go               : install golang
    -oraclejdk(8/11/17) install oraclejdk
    -openjdk          : install openjdk
    -py3(7/8/9/10)    : install python3                    (Based on package manager)
    -py2              : install python2                    (Based on package manager)                                                                       
    -pip2-f           : force install pip2                 (It is recommended to run with the -python2 option failing)                                      
    -perl             : install perl
    -ruby             : install ruby                       (If that fails, try -ruby-f)                                                                     
    -rust             : install rust
    -code             : install code-server
    -chromium         : install Chromium                   (Used with rad, crawlergo in the -k option)                                                      
    -crawl            : install crawl tools
    -phantomjs        : install PhantomJS
  
  Blue Team Tools 
    -binwalk          : install binwalk
    -binwalk-f        : force install binwalk              (It is recommended to run if the -binwalk option fails)                                          
    -clamav           : install ClamAV
    -lt               : install LogonTracer                (High hardware configuration requirements)                                                       
    -suricata         : install Suricata
    -vol              : install volatility
    -vol3             : install volatility3
  
  Red Team Tools 
    -aircrack         : install aircrack-ng
    -bypass           : install Bypass
    -goby             : install Goby                       (Requires GUI environment)                                                                       
    -wpscan           : install wpscan
    -wx               : install wxappUnpacker
    -yakit            : install yakit
  
  Red Team Infrastructure 
    -arl              : install ARL (~872 MB)              (https://github.com/TophantTechnology/ARL)                                                       
    -awvs15           : install AWVS15
    -cs45             : install CobaltStrike 4.5
    -frp              : install frp
    -interactsh       : install interactsh                 (https://github.com/projectdiscovery/interactsh)                                                 
    -merlin           : install merlin                     (https://github.com/Ne0nd0g/merlin)                                                              
    -msf              : install Metasploit
    -mobsf            : install MobSF (~1.54 GB)
    -mythic           : install mythic                     (建议使用国外地区的vps,不然部署速度太慢了)                                                       
    -nodejsscan       : install nodejsscan (~873 MB)
    -nps              : install nps
    -pupy             : install pupy                       (https://github.com/n1nj4sec/pupy)                                                               
    -rg               : install RedGuard                   (https://github.com/wikiZ/RedGuard)                                                              
    -http             : install simplehttpserver
    -sliver           : install sliver-server && client    (https://github.com/BishopFox/sliver)                                                            
    -sliver-client    : install sliver-client
    -sps              : install SharPyShell                (https://github.com/antonioCoco/SharPyShell)                                                     
    -viper            : install Viper (~2.1 GB)            (https://github.com/FunnyWolf/Viper)                                                             
  
  Vulnerable Environments
    -metarget         : install metarget                   (https://github.com/Metarget/metarget)                                                           
    -vulhub           : install vulhub (~210 MB)           (https://github.com/vulhub/vulhub)                                                               
    -vulfocus         : install vulfocus (~1.04 GB)        (https://github.com/fofapro/vulfocus)                                                            
    -TerraformGoat    : install TerraformGoat              (https://github.com/HXSecurity/TerraformGoat)                                                    
  
  Miscellaneous Services 
    -asciinema        : install asciinema
    -aa               : install aaPanel                    (https://www.aapanel.com/)                                                                       
    -bt               : install 宝塔服务
    -clash            : install clash
    -nginx            : install nginx
    -ssh              : install ssh                        (RedHat is available by default, no need to reinstall)                                           
    -ssr              : install ssr
    -zsh              : install zsh
  
  Other 
    -clear            : Clean up system usage traces
    -info             : View system information
    -optimize         : Improve device options and optimize performance
    -remove           : Uninstall some vps cloud monitoring
    -rmlock           : Run the Unlock module
    -swap             : Configuring swap partitions
    -update           : Update f8x
    -upgrade          : Upgrade some tools
  
  Author r0fus0d , feel free to submit an issue if you need to add tool support or run into problems                                                        
  |- create by ffffffff0x
  
  -----End of execution-----
  ```
#### 安装相关服务环境
可根据"bash f8x -h"中需求安装相应服务。

格式:

```bash
bash f8x -服务名称
```

------

*<u>注：本文章和工具(该工具为网络资源非本人开发)仅供学习和研究使用,请勿使用项目的技术手段用于非法用途,任何人造成的任何负面影响,与本人无关.</u>*

<u>[文章来源：http://fireworm.cc](http://fireworm.cc)</u>