搭建Vulfocus漏洞复现平台

# 相关文档：
文件：

# 目录：
 * [1. 安装环境](##1. 安装环境)

 * [2. 下载所需要的包和集成环境](##2. 下载所需要的包和集成环境)
     * [相关包](####相关包)
      * [集成安装环境](####集成安装环境)

 * [3. 拉取并开启docker](#3. 拉取并开启docker)

 * [4. 登录Vulfocus](#4. 登录Vulfocus)
 * [5. 意外状况方法解决](#5. 意外状况方法解决)
### 1. 安装环境

* 本环境为Ubantu 18.04 64位

### 2. 下载所需要的包和集成环境

#### 相关包

* <1>. 更新apt-get源

  ```bash
  apt-get update
  ```
  
* <2>. 安装docker
  ```bash
  apt-get install docker
  ```
* <3>. 安装docker-compose
  ```bash
  apt-get install -y docker-compose
  ```
#### 集成安装环境
* <1>. 切换到"/"目录,创建"f8x"并进入"f8x"目录
  ```bash
  cd /;mkdir f8x;cd f8x
  ```
* <2>. 下载f8x集成环境

  ```bash
  wget : wget -O f8x https://f8x.io/
  ```
* <3>. 可查看集成安装环境详细使用命令
  
  ```bash
  bash f8x -h
  ```



### 3. 拉取并开启docker
* <1>. 使用集成安装环境拉取并安装Vulfocus
  
  ```bash
  bash f8x -vulfocus
  ```
* <2>. 开启并运行docker
  
  ```bash
  docker run -p 80:80 -v /var/run/docker.sock:/var/run/docker.sock -e VUL_IP=0.0.0.0 vulfocus/vulfocus
  ```

### 4. 登录Vulfocus

* <1>. 输入网站域名/ip登录vulfocus
* <2>. 默认账号密码：admin/admin
* <3>. 主页-->镜像管理-->镜像管理-->一键同步(右上角)
* <4>. 同步成功，完结撒花！

### 5. 意外状况方法解决

云服务器搭建无法访问

核查方法：查看安全组策略是否开启了80端口

# 文章更新

## 更新时间：2024/07/08

因**LeouMaster**师傅的提出的相关问题，我经过测试后有关F8x的vulfocus给出的相关镜像地址已失效。我这里给出另一个搭建解决方案，因为之前我搭建成功过，我会将镜像打包在百度网盘，由大家自行下载。

vulfocus镜像打包文件：[vulfocus.tar](https://pan.baidu.com/s/1ICJarXH-mpiNOhs8lTM3GQ?pwd=fire)

## 搭建步骤

注：这里的搭建基于前面的环境基础

### 1.下载上面的文件镜像并上传至服务器

### 2.加载镜像

```
# 加载镜像vulfocus.tar的压缩包
docker load -i vulfocus.tar
# 查看当前有哪些docker
docker images
# 加载docker,端口为80
docker run -p 80:80 -v /var/run/docker.sock:/var/run/docker.sock -e VUL_IP=0.0.0.0 vulfocus/vulfocus
```

输入网站域名/ip登录vulfocus访问即可，账号密码(默认)在前面。

此镜像是之前我搭建好的镜像，且正常同步漏洞列表。(如下图)

![](.\Execution_steps_picture\1.png)

# 文章更新

## 更新时间：2024/11/23

因 **Yuan** 师傅的提出的相关问题，我经过测试后有关打包后原来 docker 中自带的漏洞Docker下载地址失效了，导致下载不了漏洞 Docker，这里给出相应解决方案。

### 1. 添加能有效获取的镜像地址

在该路径的文件` /etc/docker/daemon.json` 下添加镜像获取地址 (没有该文件的创建即可)

```
vi /etc/docker/daemon.json
{
"registry-mirrors": [
    "https://dockerproxy.com",
    "https://hccwwfjl.mirror.aliyuncs.com",
    "https://docker.1ms.run",
    "https://doublezonline.cloud",
    "https://dislabaiot.xyz",
    "https://docker.fxxk.dedyn.io",
    "https://dockerpull.org",
    "https://docker.unsee.tech",
    "https://hub.rat.dev",
    "https://docker.1panel.live",
    "https://docker.1panelproxy.com",
    "https://proxy.1panel.live",
    "https://docker.nastool.de",
    "https://docker.zhai.cm",
    "https://docker.5z5f.com",
    "https://a.ussh.net",
    "https://docker.udayun.com",
    "https://hub.geekery.cn",
    "https://docker.anye.in"

]
}
```

***注：以上地址如果都失效可以自行网上搜索相关有效地址再重复进行以下步骤***

### 2. 重新加载

```
# 重新加载相关配置文件
systemctl daemon-reload
# 重新启动Docker
systemctl resteart docker
```

![img](.\Execution_steps_picture\1-1.png)

![img](.\Execution_steps_picture\2.png)

![img](.\Execution_steps_picture\3.png)

![img](.\Execution_steps_picture\4.png)

*<u>注：本文章和工具(该工具为网络资源非本人开发)仅供学习和研究使用,请勿使用项目的技术手段用于非法用途,任何人造成的任何负面影响,与本人无关.</u>*

<u>[文章来源：http://fireworm.cc](http://fireworm.cc)</u>

